#!/bin/sh

MASTER_PAGE_MAIN_SETTINGS_RESULT_MSG=""
MASTER_PAGE_MAIN_SETTINGS_RESULT_OK=0
MASTER_PAGE_MAIN_SETTINGS_RESULT_ERROR=1

MASTER_PAGE_MAIN_SETTINGS_RESULT_CODE=${MASTER_PAGE_MAIN_SETTINGS_RESULT_ERROR}
MASTER_PAGE_MAIN_SETTINGS_RESULT_ROLLING=0

master_page_main_settings() 
{
	#debug_print "${0}" "${LINENO}" 'in function "master_page_main_settings"'

        local item_number=5
		local menu_list=""
        for (( i=1; i<=$item_number; i=i+1 ))
        do
                eval menu_item=\$MASTER_PAGE_MAIN_SETTINGS_ITEM_$i
                menu_list="$menu_list$i \"$menu_item\" "
        done

        PORTAL_IPV4_ADDR=`ip -f inet -o addr show eth0 | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g'`
        [ "${PORTAL_IPV4_ADDR}" = "" ] && PORTAL_IPV4_ADDR="-"	
        PORTAL_IPV6_ADDR=`ip -f inet6 -o addr show eth0 | grep -v 'local' | grep -v 'dynamic' | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g' | tr '[a-z]' '[A-Z]'`
        
        local upcase=$(echo ${PORTAL_IPV6_ADDR:0:5} | tr '[a-z]' '[A-Z]')
        if [ "${upcase}" = "FE80:" ]; then
            PORTAL_IPV6_ADDR="-"
        else
            [ "${PORTAL_IPV6_ADDR}" = "" ] && PORTAL_IPV6_ADDR="-"
        fi 


        CONS_PORTAL_IPV4_ADDR="Default IPv4 address: ${PORTAL_IPV4_ADDR}"
        CONS_PORTAL_IPV6_ADDR="Default IPv6 address: ${PORTAL_IPV6_ADDR}"

        tp_menu_ok \
        "${MASTER_PAGE_MAIN_SETTINGS_TITLE}" \
        "Host name: `hostname`\n${CONS_PORTAL_IPV4_ADDR}" \
        "${MASTER_PAGE_MAIN_SETTINGS_LABEL_OK}" \
        "${menu_list}"

	# no error cases
	MASTER_PAGE_MAIN_SETTINGS_RESULT_CODE=${MASTER_PAGE_MAIN_SETTINGS_RESULT_OK}
	
	if [ "${TP_MENU_OK_RESULT_CODE}" == "${TP_MENU_OK_RESULT_CANCEL}" ]; then
		MASTER_PAGE_MAIN_SETTINGS_RESULT_ROLLING=0
		return
	fi
	
	local pages_array=""
	case ${TP_MENU_OK_RESULT_SELECT} in
		1) pages_array="master_page_ms_network_conf" ;;
		#2) pages_array="master_page_ha" ;;
		#2) pages_array="master_page_data_network_conf" ;;
		2) pages_array="master_page_ping" ;;
		3) pages_array="master_page_accounts_mngt" ;;
		#4) save_audit_log "all.systemEvents.textui.logoff" "600"; exit 0 ;;
                4) pages_array="master_page_sshd_enable" ;;
		5) exit 0 ;;
		*) ;;
	esac
	pages_roller "$pages_array"
}
